; Diagnostic ROM part 0
;
; Start of Diag part 0: test CPU
; Test 0  Flash
;
; 
; Author Dwight Elvey
;
; Converted to standard assembler Hans Otten, 2025
;
; Standard Defines KIM-1
;
; I/O in 6530-002
;
SAD     =     $1740             ; 6530 A DATA
PADD    =     $1741             ; 6530 A DATA DIRECTION
SBD     =     $1742             ; 6530 B DATA
PBDD    =     $1743             ; 6530 B DATA DIRECTION
CLK1T   =     $1744             ; DIV BY 1 TIME
CLK8T   =     $1745             ; DIV BY 8 TIME
CLK64T  =     $1746             ; DIV BY 64 TIME
CLKKT   =     $1747             ; DIV BY 1024 TIME
CLKRDI  =     $1747             ; READ TIME OUT BIT
CLKRDT  =     $1746             ; READ TIME
;
;
; I/O in 6530-002
;
SAD1     =     $1700             ; 6530 A DATA
PADD1    =     $1701             ; 6530 A DATA DIRECTION
SBD1     =     $1702             ; 6530 B DATA
PBDD1    =     $1703             ; 6530 B DATA DIRECTION
CLK1T1   =     $1704             ; DIV BY 1 TIME
CLK8T1   =     $1705             ; DIV BY 8 TIME
CLK64T1  =     $1706             ; DIV BY 64 TIME
CLKKT1   =     $1707             ; DIV BY 1024 TIME
CLKRDI1  =     $1707             ; READ TIME OUT BIT
CLKRDT1  =     $1706             ; READ TIME

; Zero page 6530--002
;
;
INH     =     $F9               ; INPUT BUFFER
POINTL  =     $FA               ; LSB OF OPEN CELL
POINTH  =     $FB               ; MSB OF OPEN CELL
CNT		=	  $FC				; counter
;
; KIM-1 Routines
;
SCANDS  = $1F1F
KEYIN   = $1F40
GETKEY  = $1F6A
;
; Start of Diag part 0: test CPU
; Test 0  Flash
; Switch setting:
;  S6 on
;  --
;  S0 on
;  S1 on
;  S2 on
;  S3 on
;  This is a minimal test of the processor. All it does
; is slowly flash the Green LED on the diagnostic board.
; It is initiated by the reset switch, on the keyboard of the KIM-1 ( RS ).
; This test only uses the processor, addresss decoder and data bus.
; If it fails to run. It will be a problem in one of these areas.
; This test does not use any of the RAM in either the 2102s or in
; either of the 6530 RAM areas. It only uses a few instructions and
; is not a complete CPU diagnostic.
; Remember the processor includes clocks and reset vector and possible
; NMI stuck.
;
; As a bonous some of the extra space has the program Astroids from the
; First Book of Kim. It the normal KIM-1 monitor is running, one can
; play if by setting the same switches as Flash except DB to off.
; set the address at 0E00 and GO.
; Use 0 and 3 to move your space ship to avoid the astroids.;
;
	.ORG $0C00
;
; Clear or set status LED
;
RESET
;
; Debug boot flashs green led about 2 seconds

          LDY #$00
          LDX #$00
STATUS    STA $1000		; light status LED (or DIM, depends on bit 0
;
; test the CPU
;
LOOP      EOR #$01
          EOR #$01
          EOR #$01
          EOR #$01
          EOR #$01
          EOR #$01
          EOR #$01
          EOR #$01
          EOR #$01
          EOR #$01
          EOR #$01
          EOR #$01
          EOR #$01
          EOR #$01
          INX
          BNE LOOP
          INY
          BNE LOOP
          EOR #$01			; must be odd number
          JMP STATUS
;
HERE1
		.FILL (ASTEROID - HERE1)&$FFF, 0
; Asteroids at 0E00
;		  
; Zeropage
; 
ZAS0	= $E0
ZAS1	= $E1
ZAS2	= $E2
ZAS3	= $E3
ZAS4	= $E4
ZAS5	= $E5
ZAS6	= $E6
ZAS7	= $E7
ZAS8	= $E8
ZAS9	= $E9
; 
; RAM in 6530
;
RAM1 = $17FA
RAM2 = $17FB

		  .ORG $0E00
ASTEROID  LDX #$FF
          TXS
          LDA #$0E
          STA RAM2
          LDA #$00			; initialize counter
          STA RAM1
          STA $INH
          STA $POINTL
          STA $POINTH
          LDX #$06			; initialize zeropage
INIT      LDA DEFZP,X
          STA ZAS2,X
          DEX
          BPL INIT
TOGG      LDA ZAS8			; toggle ZAS8
          EOR #$FF
          STA ZAS8			; delay betwen flashes
          LDX #$08			; display end and
LITE      JSR $0E53			; check for match
          JSR $0EA4
          DEX
          BNE LITE
          JSR KEYIN			; set directional regs
          JSR GETKEY		; get keyboard entry
          CMP #$15			; valid key?
          BPL TOGG			
          CMP #$00			; key 0?
          BEQ LEFT			; go left
          CMP #$03
          BEQ RT			; go right
          BNE TOGG
LEFT      ASL ZAS7			; shift craft left
          LDA #$40			; left hand edge?
          CMP ZAS7
          BNE TOGG
RT        LSR ZAS7			; shift right
          BNE TOGG
          SEC				; off edge return
          ROL ZAS7
          BNE TOGG
;
; display subroutine		  
;
DISP      LDA #$7F			; port to output
          STA PADD
          LDA #$09			; init digit
          STA SBD
          LDA #$20			; bit position to 6th bit
          STA ZAS0
BITS      LDY #$02			; 3 bytes
          LDA #$00			; zero character
          STA ZAS1
BYTE      LDA (ZAS2),Y		; get byte
          AND ZAS0			; nth bit is 1
          BEQ NOBT
          LDA ZAS1
          ORA ZAS4,Y		; update character
          STA ZAS1
NOBT      DEY
          BPL BYTE			; next byte
          LDA ZAS1			; char in accum
          CPY ZAS8			; ship on?
          BNE DIGT
          LDY ZAS0			; is this ship digit?
          CPY ZAS7
          BNE DIGT			; add in ship
          ORA #$08
DIGT      EOR #$00
          STA SAD			; light digit
          LDA #$30
          STA CLK64T1
DELA      LDA CLKRDI1		; time up?
          BEQ DELA
          LDA #$00			; turn on segments
          STA SAD
          INC SBD			; next digit
          INC SBD
          LSR $E0
          BNE BITS			; more bits
          RTS
;
; Check routine
;		  
CHEK      DEC ZAS9			; times thru cont
          BNE MORE
          LDA #$20
          STA ZAS9
          TXA
          PHA
          LDX #$FD			; negative 3 in X
          SED
          SEC
NXBT      LDA CNT,X			; increment counter in bytes
          ADC #$00			; in display area
          STA CNT,X
          INX
          BNE NXBT
          CLD
          PLA
          TAX
          INC ZAS2		
          LDA ZAS2
MORE      CMP #$30
          BEQ RECY			; all groups finished?
MATCH     LDY #$00			; recycle asteroid filed
          LDA ZAS7			; load craft position
          AND (ZAS2),Y		; and with asteroid byte
          BNE FIN
          RTS
RECY      LDA #$00
          STA ZAS2			; go thru asteroid field
          BEQ MATCH
FIN       JSR SCANDS		; display count
          JSR KEYIN
          JSR GETKEY
          CMP #$04
          BNE FIN
          JMP ASTEROID
		  
DEFZP   .BYTE   ASFLD&255        ; LOW POINTER, ASTEROID
        .BYTE   ASFLD/256        ; HIGH POINTER, ASTEROID
        .BYTE   $08              ; MASK, BOTTOM SEGMENT
        .BYTE   $40              ; MASK, MIDDLE SEGMENT
        .BYTE   $01              ; MASK, TOP SEGMENT
        .BYTE   $04              ; CRAFT POSITION
        .BYTE   $FF              ; FLAG (SHIP ON)

; ***** ASTEROID FIELD *****

ASFLD   .BYTE $00, $00, $00, $04, $00, $08, $00, $06, $12, $00, $11, $00, $05, $00, $2C, $00
        .BYTE $16, $00, $29, $00, $16, $00, $2B, $00, $26, $00, $19, $00, $17, $00, $38, $00
        .BYTE $2E, $00, $09, $00, $1B, $00, $24, $00, $15, $00, $39, $00, $0D, $00, $21, $00
        .BYTE $10, $00, $00		  
		  
HERE2
		.FILL (VECTOR - HERE2)&$FFF, 0

;
; Reset vectors
;	

		  .ORG $FFFA
VECTOR		  
          .BYTE RESET&255
          .BYTE RESET/256
          .BYTE RESET&255
          .BYTE RESET/256
          .BYTE RESET&255
          .BYTE RESET/256
		 .END